function  [ztrata u y b P]=rizeni(H,ny_0,ny,system,apriori,seed)
sigma=system.sigma;
horizont=size(H,1)+2;

y=zeros(1,horizont);
b=zeros(1,horizont-1);
P=zeros(1,horizont-1);
u=zeros(1,horizont-1);
ztrata=0;

y(1)=apriori(1);
b(1)=apriori(2);
P(1)=apriori(3);


u(1)=-ny_0*sigma/sqrt(P(1))*sign(y(1)*b(1));
y(2)=y(1)+system.b*u(1)+sigma*seed(1);
K=u(1)*P(1)/(P(1)*u(1)^2+sigma^2);
b(2)=b(1)+K*(y(2)-y(1)-b(1)*u(1));
P(2)=(1-K*u(1))*P(1);   
ztrata=ztrata+(y(2)-system.yr(1))^2;

    for i=2:size(H,1)
        eta=abs(y(i))/sigma;
        beta=abs(b(i))/sqrt(P(i));
        state=[eta beta];
        
        index=find_in_hyperstate5(state, H(i-1,:,:));
        
        %plot(H(i-1,:,1),H(i-1,:,2),'g.'); hold on; plot(H(i-1,index,1), H(i-1,index,2),'r+'); plot(state(1), state(2),'b.');  hold off
        
        u(i)=-ny(i-1,index)*sigma/sqrt(P(i))*sign(y(i)*b(i));
        
        y(i+1)=y(i)+system.b*u(i)+sigma*seed(i);
        K=u(i)*P(i)/(P(i)*u(i)^2+sigma^2);
        b(i+1)=b(i)+K*(y(i+1)-y(i)-b(i)*u(i));
        P(i+1)=(1-K*u(i))*P(i);   
        
        ztrata=ztrata+(y(i+1)-system.yr(i))^2;
    end
    i=i+1;
    eta=abs(y(i))/sigma;
    beta=abs(b(i))/sqrt(P(i));
    u(i)=-eta*beta/(1+beta^2)*sigma/sqrt(P(i))*sign(y(i)*b(i));
    
    y(i+1)=y(i)+system.b*u(i)+sigma*randn;
    K=u(i)*P(i)/(P(i)*u(i)^2+sigma^2);
    b(i+1)=b(i)+K*(y(i+1)-y(i)-b(i)*u(i));
    P(i+1)=(1-K*u(i))*P(i); 
    ztrata=ztrata+(y(i+1)-system.yr(i))^2;
    
 end
